﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.ServicesWrapper.EVS
{
    /// <summary>
    /// EVS Constants used when querying.
    /// </summary>
    public class CTSConstant
    {
        private int _maxExpansionSize = 200;
        private int _maxSearchSize = 40;

        /// <summary>
        /// EVS maximum expansion depth when querying.
        /// value = 0  -> no size limit
        /// value < 0 -> value = 0
        /// value > 0  max expansion size = value
        /// </summary>
        public int MaxExpansionSize
        {
            get { return _maxExpansionSize; }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    if (value < 0)
                        value = 0;
                    _maxExpansionSize = value;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }
        /// <summary>
        /// The maximum number of concepts to return.
        /// </summary>
        public int MaxSearchSize
        {
            get { return _maxSearchSize; }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    if (value < 0)
                        value = 0;
                    _maxSearchSize = value;
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }
    }
}
